//
//  GHWellnessData.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 6/9/17.
//  Copyright © 2017 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 *  The GHWellnessData class provides detailed information about FIT data.
 */
@interface GHWellnessData : NSObject <NSCoding>

/** 
 * Start time of the data record in UTC
 */
@property (nullable, nonatomic) NSDate *startTimestamp;

/**
 * End time of the data record in UTC
 */
@property (nullable, nonatomic) NSDate *endTimestamp;

/**
 * Duration of the data record in seconds
 */
@property (nullable, nonatomic) NSNumber *duration;

/**
 * Number of steps recorded for the time period
 */
@property (nullable, nonatomic) NSNumber *steps;

/**
 * Activities recorded for the time period. refer to GHActivityType
 */
@property (nullable, nonatomic) NSArray<NSString *> *activities;

/**
 * Distance recorded for the time period in meters
 */
@property (nullable, nonatomic) NSNumber *distance;

/**
 * Calories burned due to activity for the time period
 */
@property (nullable, nonatomic) NSNumber *activeCalories;

/**
 * Total calories burned for the time period
 */
@property (nullable, nonatomic) NSNumber *totalCalories;

/**
 * Average heart rate for the time period
 */
@property (nullable, nonatomic) NSNumber *heartRate;

/**
 * Ascent recorded for the time period in meters
 */
@property (nullable, nonatomic) NSNumber *ascent;

/**
 * Descent recorded for the time period in meters
 */
@property (nullable, nonatomic) NSNumber *descent;

/**
 * Number of minutes of moderately activity for the time period
 */
@property (nullable, nonatomic) NSNumber *moderateActivityMinutes;

/**
 * Number of minutes of vigorous activity for the time period
 */
@property (nullable, nonatomic) NSNumber *vigorousActivityMinutes;

/**
 * Intensity of the movement for the time period
 */
@property (nullable, nonatomic) NSNumber *intensity;


@end
